#ifndef __CPen__
#define __CPen__

#include "../Basics/CAlphaColour.hpp"
using Exponent::GUI::Basics::CAlphaColour;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CPen CPen.hpp
			 * @brief Used for drawing lines
			 *
			 * @date 01/10/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CPen.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CPen
			{
			public:

//	===========================================================================

				/**
				 * Construction
				 */
				CPen();

				/**
				 * Destruction
				 */
				virtual ~CPen();

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Initialise
					 * @param width The width in pixels
					 * @param drawContext The windows drawing context
					 * @param colour The colour you want to use for the pen
					 */
					void initialise(const long width, HDC drawContext, const CAlphaColour &colour);

					/**
					 * Get the pens HDC
					 * @retval const HDC The pen context
					 */
					const HDC getPenHdc() const { return m_hdc; }

					/**
					 * Get the pen
					 * @retval const HPEN The widnows pen
					 */
					const HPEN getPen() const { return m_pen; }

					/**
					 * Set the pen to the null pen (draws transparent)
					 */
					void setPenToNullPen();
				/** @cond */
				#else
				/** @endcond */
					/**
					 * Initialise
					 * @param size The width in pixels
					 * @param drawContext The mac drawing context
					 * @param colour The colour you want to use for the pen
					 */
					void initialise(CGContextRef drawContext, long size, const CAlphaColour &colour);

					/**
					 * Get the draw context
					 * @retval CGContextRef The mac context
					 */
					CGContextRef getContextRef() const { return m_drawContext; }
				/** @cond */
				#endif
				/** @endcond */

				/**
				 * Deinitialise
				 */
				void uninitialise();

//	===========================================================================

				/**
				 * Set the pen
				 * @param width The width in pixels
				 * @param colour The colour you want to use for the pen
				 */
				void setPen(const long width, const CAlphaColour &colour);

				/**
				 * Set the width
				 * @param width The width in pixels
				 */
				void setWidth(const long width);

				/**
				 * Set the colour
				 * @param colour The colour you want to use for the pen
				 */
				void setColour(const CAlphaColour &colour);

//	===========================================================================

				/**
				 * Get hte colour of the pen
				 * @retval const CAlphaColour& The pen colour
				 */
				const CAlphaColour &getColour() const { return m_colour; }

				/**
				 * Get the width of the pen
				 * @retval long The pen width
				 */
				long getWidth() const { return m_width; }

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Create the pen
				 */
				virtual void createPen();

				/**
				 * Delete the pen
				 */
				virtual void deletePen();

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					HGDIOBJ m_hOld;				/**< The old pen */
					HDC m_hdc;					/**< Device context */
					HPEN m_pen;					/**< The pen */
				/** @cond */
				#else
				/** @endcond */
					CGContextRef m_drawContext;	/**< Host drawing context */
				/** @cond */
				#endif
				/** @endcond */

				long m_width;					/**< The width */
				CAlphaColour m_colour;			/**< The colour */

			};
		}
	}
}
#endif	// End of CPen.hpp